/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.legacy.blue_skies.registries.SkiesDimensions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class DawnModifier
extends Modifier
implements ConditionalStatModifierHook,
ProjectileHitModifierHook {
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT, TinkerHooks.PROJECTILE_HIT);
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, int level, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getPlayer();
        Level world = player.m_20193_();
        if (world.m_46468_() < 24000L && world.m_46468_() > 22200L || player.f_19853_.m_46472_().equals((Object)SkiesDimensions.everdawnKey())) {
            event.setNewSpeed(event.getNewSpeed() + (float)(3 * level) * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED));
        }
    }

    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        Player player = context.getPlayerAttacker();
        Level world = player.m_183503_();
        if (world.m_8044_() < 24000L && world.m_8044_() > 22200L || player.f_19853_.m_46472_().equals((Object)SkiesDimensions.everdawnKey())) {
            return damage + (float)(3 * level) * tool.getMultiplier((INumericToolStat)ToolStats.ATTACK_DAMAGE);
        }
        return damage;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        Level world = living.m_20193_();
        int level = modifier.getLevel();
        if (stat == ToolStats.DRAW_SPEED && (world.m_46468_() < 24000L && world.m_46468_() > 22200L || living.f_19853_.m_46472_().equals((Object)SkiesDimensions.everdawnKey()))) {
            return (float)((double)baseValue + 0.1 * (double)level);
        }
        return 0.0f;
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if ((attacker.m_20193_().m_46468_() < 24000L && attacker.m_20193_().m_46468_() > 22200L || attacker.f_19853_.m_46472_().equals((Object)SkiesDimensions.everdawnKey())) && projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            arrow.m_36781_(arrow.m_36789_() + 0.5 * (double)modifier.getLevel());
        }
        return false;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        Level world = player.m_20193_();
        if ((world.m_46468_() < 24000L && world.m_46468_() > 22200L || player.f_19853_.m_46472_().equals((Object)SkiesDimensions.everdawnKey())) && (harvest || tool.hasTag(TinkerTags.Items.RANGED)) && key == TooltipKey.SHIFT) {
            if (harvest) {
                this.addStatTooltip(tool, ToolStats.ATTACK_DAMAGE, TinkerTags.Items.MELEE_OR_UNARMED, 3 * level, tooltip);
                this.addStatTooltip(tool, ToolStats.MINING_SPEED, TinkerTags.Items.HARVEST, 3 * level, tooltip);
            } else {
                this.addStatTooltip(tool, ToolStats.DRAW_SPEED, TinkerTags.Items.RANGED, 0.1f * (float)level, tooltip);
                this.addStatTooltip(tool, ToolStats.PROJECTILE_DAMAGE, TinkerTags.Items.RANGED, 0.5f * (float)level, tooltip);
            }
        }
    }
}

